<?php

namespace App\Admin\Controllers;

use OpenAdmin\Admin\Controllers\AdminController;
use OpenAdmin\Admin\Form;
use OpenAdmin\Admin\Grid;
use OpenAdmin\Admin\Show;
use \App\Models\Enquiry;

class EnquiryController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Enquiry';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Enquiry());
        $grid->model()->latest();

        $grid->column('id', __('Id'));
        $grid->column('type', __('Type'));
        $grid->column('name', __('Name'));
        $grid->column('email', __('Email'));
        $grid->column('number', __('Number'));
        $grid->column('message', __('Message'));
        $grid->column('status', __('Status'))
            ->using([0 => 'Unread', 1 => 'Read'])
            ->label([0 => 'warning', 1 => 'success']);
        $grid->column('created_at', __('Created at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });
        $grid->column('updated_at', __('Updated at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });

        $grid->filter(function($filter) {
            $filter->disableIdFilter();
            $filter->like('type', __('Type'));
            $filter->equal('status', __('Status'))->select([
                0 => 'Unread',
                1 => 'Read',
            ]);
            $filter->between('created_at', __('Created At'))->datetime();
        });

        $grid->disableCreateButton();

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Enquiry::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('type', __('Type'));
        $show->field('name', __('Name'));
        $show->field('email', __('Email'));
        $show->field('number', __('Number'));
        $show->field('message', __('Message'));
        $show->field('status', __('Status'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Enquiry());

        $form->text('type', __('Type'));
        $form->text('name', __('Name'));
        $form->email('email', __('Email'));
        $form->text('number', __('Number'));
        $form->textarea('message', __('Message'));
        $form->switch('status', __('Status'))
            ->help('Mark as Read');

        return $form;
    }
}
