<?php

namespace App\Admin\Controllers;

use OpenAdmin\Admin\Controllers\AdminController;
use OpenAdmin\Admin\Form;
use OpenAdmin\Admin\Grid;
use OpenAdmin\Admin\Show;
use \App\Models\SectionTemplate;

class SectionTemplateController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'SectionTemplate';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new SectionTemplate());

        $grid->column('id', __('Id'));
        $grid->column('hint_image', __('Hint image'));
        $grid->column('section_name', __('Section name'));
        $grid->column('section_json', __('Section json'));
        $grid->column('created_at', __('Created at'));
        $grid->column('updated_at', __('Updated at'));

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(SectionTemplate::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('hint_image', __('Hint image'));
        $show->field('section_name', __('Section name'));
        $show->field('section_json', __('Section json'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new SectionTemplate());

        $form->text('hint_image', __('Hint image'));
        $form->text('section_name', __('Section name'));
        $form->text('section_json', __('Section json'));

        return $form;
    }

    
}
