<?php

namespace App\Admin\Controllers;

use OpenAdmin\Admin\Controllers\AdminController;
use OpenAdmin\Admin\Form;
use OpenAdmin\Admin\Grid;
use OpenAdmin\Admin\Show;
use \App\Models\Setting;
use \App\Models\Page;

class SettingController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Setting';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Setting());

        $grid->column('id', __('Id'));
        $grid->column('name', __('Name'));
        // $grid->column('value', __('Value'));
        // $grid->column('created_at', __('Created at'));
        // $grid->column('updated_at', __('Updated at'));

        $grid->actions(function ($actions) {
            $actions->disableDelete(); // Removes the delete button
            // $actions->disableEdit();   // Removes the edit button
            $actions->disableView();   // Removes the view button
        });

        $grid->disableCreateButton();

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Setting::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('name', __('Name'));
        $show->field('value', __('Value'));
        $show->field('created_at', __('Created at'));
        $show->field('updated_at', __('Updated at'));

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Setting());

        // Disable the delete button on the edit form
        $form->tools(function (Form\Tools $tools) {
            $tools->disableDelete(); // Hides the delete button from the tools section
            $tools->disableView();   // Hides the view button from the tools section
            // $tools->disableList();  // Hides the list button
        });
        
        $form->html('<style>
                #embed-start_a_business { 
                    margin-left: 30px; 
                }
                #embed-registration_and_filings {
                    margin-left: 30px;
                }
            </style>');
        if($form->isCreating())
            $form->text('name', __('Name'))->required();

        $form->editing(function (Form $form) {
            // site_logo ---------------------------------------------------------------------------------------
            if($form->model()->name === 'site_logo') {
                $value = $form->model()->value;
                $form->image('value', __('Site Logo'))
                    ->uniqueName()
                    ->move('settings')
                    ->required()
                    ->help('Upload Site Log');
            } 
            // site_favicon ---------------------------------------------------------------------------------
            if ($form->model()->name === 'site_favicon') {
                $form->image('value', __('Site Favicon'))
                    ->uniqueName()
                    ->move('settings')
                    ->required()
                    ->help('Upload Site Favicon');
            } 
            if($form->model()->name === 'email') {
                $form->email('value', __('Email'));
            }
            if($form->model()->name === 'phone') {
                $form->mobile('value', __('Phone'));
            }
            if($form->model()->name === 'address') {
                $form->textarea('value', __('Address'));
            }
            // header_nav ---------------------------------------------------------------------------------------
            if($form->model()->name === 'header_nav') {
                $form->embeds('value', __('Header Navigation'), function ($form) {
                    $form->select('home', 'Home Page')->options(Page::pluck('name', 'id'));
                    $form->embeds('start_a_business', _('Start a Business'), function ($form) {
                        for($i=0; $i<4; $i++){
                            $form->embeds('side_nav_'.$i, _('Side Nav '.$i+1), function ($form) {
                                $form->text('title', 'Title');
                                $form->textarea('paragraph', 'Paragraph');
                                $form->embeds('nav_items', 'Navigation Items', function ($form) {
                                    for($j=0;$j<5;$j++){
                                        $form->select('page_'.$j, 'Page '.$j+1)->options(\App\Models\Page::pluck('name', 'id'));
                                    }
                                });
                            });
                        }
                    });
                    $form->embeds('registration_and_filings', _('Registration & Filings'), function ($form) {
                        for($i=0; $i<4; $i++){
                            $form->embeds('side_nav_'.$i, _('Side Nav '.$i+1), function ($form) {
                                $form->text('title', 'Title');
                                $form->textarea('paragraph', 'Paragraph');
                                $form->embeds('nav_items', 'Navigation Items', function ($form) {
                                    for($j=0;$j<5;$j++){
                                        $form->select('page_'.$j, 'Page '.$j+1)->options(\App\Models\Page::pluck('name', 'id'));
                                    }
                                });
                            });
                        }
                    });
                    $form->divider('Other Pages');
                    for($i=0; $i<5; $i++){
                        $form->select('page_'.$i, 'Page '.$i+1)->options(\App\Models\Page::pluck('name', 'id'));
                    }
                });
            }
            // footer_quick_links --------------------------------------------------------------------------
            if($form->model()->name === 'footer_quick_links') {
                $form->table('value', 'Quick Links', function ($table) {
                    $table->select('page', 'Select Page')
                        ->options(Page::pluck('name', 'id'))
                        ->rules('nullable|exists:pages,id');
                });
            }
            // footer_service_links --------------------------------------------------------------------------
            if($form->model()->name === 'footer_service_links') {
                $form->table('value', 'Services Links', function ($table) {
                    $table->select('page', 'Select Page')
                        ->options(Page::pluck('name', 'id'))
                        ->rules('nullable|exists:pages,id');
                });
            }
            // footer_featured_services --------------------------------------------------------------------------
            if($form->model()->name === 'footer_featured_services') {
                $form->table('value', 'Featured Links', function ($table) {
                    $table->select('page', 'Select Page')
                        ->options(Page::pluck('name', 'id'))
                        ->rules('nullable|exists:pages,id');
                });
            }
            // social_links --------------------------------------------------------------------------
            if($form->model()->name === 'social_links') {
                $form->embeds('value', 'Social Links', function ($json) {
                    $json->url('facebook');
                    $json->url('instagram');
                    $json->url('linked_in');
                    $json->url('tweeter_x');
                });
            }

        });

        $form->saving(function (Form $form) {
            $value = request('value');
            // site-logo ----------------------------------------------------------------------
            if ($form->model()->name == 'site_logo') {
                if (request()->hasFile('value')) {
                    $file = request()->file('value');
                    $imagePath = $file->store('settings', 'public');
                    $value = $imagePath;
                } else {
                    $value = $form->model()->value;
                }
            }
            // site-site_favicon ----------------------------------------------------------------------
            if ($form->model()->name == 'site_favicon') {
                if (request()->hasFile('value')) {
                    $file = request()->file('value');
                    $imagePath = $file->store('settings', 'public');
                    $value = $imagePath;
                } else {
                    $value = $form->model()->value;
                }
            }
            
            // Always encode as JSON before saving
            $form->model()->value = $value;
        });

        return $form;
    }
}
