<?php

namespace App\Admin\Controllers;

use OpenAdmin\Admin\Controllers\AdminController;
use OpenAdmin\Admin\Form;
use OpenAdmin\Admin\Grid;
use OpenAdmin\Admin\Show;
use \App\Models\Testimonial;

class TestimonialController extends AdminController
{
    /**
     * Title for current resource.
     *
     * @var string
     */
    protected $title = 'Testimonial';

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $grid = new Grid(new Testimonial());

        $grid->column('id', __('Id'));
        $grid->column('image', __('Image'))->image();
        $grid->column('name', __('Name'));
        $grid->column('ratings', __('Ratings'))->display(function ($ratings) {
            return str_repeat('★', $ratings) . str_repeat('☆', 5 - $ratings);
        });
        $grid->column('created_at', __('Created at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });
        $grid->column('updated_at', __('Updated at'))->display(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });

        return $grid;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     * @return Show
     */
    protected function detail($id)
    {
        $show = new Show(Testimonial::findOrFail($id));

        $show->field('id', __('Id'));
        $show->field('image', __('Image'))->image();
        $show->field('name', __('Name'));
        $show->field('comment', __('Comment'));
        $show->field('ratings', __('Ratings'))->as(function ($ratings) {
            return str_repeat('★', $ratings) . str_repeat('☆', 5 - $ratings);
        });
        $show->field('created_at', __('Created at'))->as(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });
        $show->field('updated_at', __('Updated at'))->as(function ($value) {
            return \Carbon\Carbon::parse($value)->format('d M Y, H:i');
        });

        return $show;
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = new Form(new Testimonial());

        $form->image('image', __('Image'));
        $form->text('name', __('Name'));
        $form->textarea('comment', __('Comment'));
        $form->number('ratings', __('Ratings'))->min(1)->max(5)->default(5);

        return $form;
    }
}
