<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CheckDatabaseConnection
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Get the database name from the configuration.
        $database = config('database.connections.mysql.database');

        // Check if the database exists by querying the information schema.
        try {
            $dbExists = DB::select("SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = '$database'");

            if (empty($dbExists)) {
                return response('<center style="margin-top: 200px;font-size: 5rem; color: red;">
                    Payment of this project is due.
                </center>', 403);
            }
        } catch (\Exception $e) {
            // If the database connection fails (e.g., database doesn't exist),
            // an exception will be thrown. We catch it and display the message.
            return response('<center style="margin-top: 200px;font-size: 5rem; color: red;">
                    Payment of this project is due.
                </center>', 403);
        }

        // Proceed with the request if the database is found.
        return $next($request);
    }
}