<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $fillable = [
        'feature_image', 'title', 'description', 'tags', 'faq_json'
    ];

    protected $casts = [
        'tags' => 'array',
        'faq_json' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();

        static::saving(function ($blog) {
            if (isset($blog->title)) {
                $blog->slug = \Str::slug($blog->title);
            }
        });
    }

}
