<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HomePage extends Model
{
    protected $table = 'home_page';
    protected $fillable = ['hint_image', 'section_name', 'section_json'];

    protected $casts = [
        'section_json' => 'array',
    ];

    public function setSectionJsonAttribute($value)
    {
        // Ensure we have an array
        $sectionJson = is_array($value) ? $value : json_decode($value, true) ?? [];
        
        // service section ---------------------------------------------------------------
        if($this->section_name == 'services_section') {
            // Process cards if they exist in the section_json
            if (isset($sectionJson['cards']) && is_array($sectionJson['cards'])) {
                foreach ($sectionJson['cards'] as $index => &$card) {
                    // Handle image upload/processing for each card
                    if (isset($card['image']) && $card['image'] instanceof \Illuminate\Http\UploadedFile) {
                        \Log::info('Image is an instance of UploadedFile');
                        $imagePath = $card['image']->store('home/cards', 'public');
                        $card['image'] = $imagePath;
                    } elseif (isset($card['current_image']) && is_string($card['current_image'])) {
                        \Log::info('Image is a string, retaining existing value');
                        $card['image'] = $card['current_image'];
                    } else {
                        \Log::info('No valid image provided, setting to null');
                        $card['image'] = null;
                    }
                    
                    // Ensure other card fields are properly formatted
                    $card['title'] = $card['title'] ?? null;
                    $card['description'] = $card['description'] ?? null;
                    $card['link'] = $card['link'] ?? null;
                }

                // Ensure required fields exist
                $sectionJson['heading'] = $sectionJson['heading'] ?? null;
                $sectionJson['sub_heading'] = $sectionJson['sub_heading'] ?? null;
            }
        }

        // hero section ---------------------------------------------------------------
        if($this->section_name == 'hero_section') {
            // Process hero section fields
            if (isset($sectionJson['images']) && is_array($sectionJson['images'])) {
                foreach ($sectionJson['images'] as $idx => $img) {
                    if ($img instanceof \Illuminate\Http\UploadedFile) {
                        $imagePath = $img->store('home/hero', 'public');
                        $sectionJson['images'][$idx] = $imagePath;
                    } elseif (is_string($img)) {
                        // Retain existing image path
                        $sectionJson['images'][$idx] = $img;
                    } else {
                        $sectionJson['images'][$idx] = null;
                    }
                }
            } else {
                $sectionJson['images'] = $sectionJson['current_images'];
            }

            // Ensure required fields exist
            $sectionJson['heading'] = $sectionJson['heading'] ?? null;
            $sectionJson['sub_heading'] = $sectionJson['sub_heading'] ?? null;
            $sectionJson['paragraph'] = $sectionJson['paragraph'] ?? null;
        }

        // service section ---------------------------------------------------------------
        if($this->section_name == 'choosing_topfilings_section') {
            // Process cards if they exist in the section_json
            if (isset($sectionJson['menus']) && is_array($sectionJson['menus'])) {
                foreach ($sectionJson['menus'] as $index => &$card) {
                    // Handle image upload/processing for each card
                    if (isset($card['image']) && $card['image'] instanceof \Illuminate\Http\UploadedFile) {
                        \Log::info('Image is an instance of UploadedFile');
                        $imagePath = $card['image']->store('home/choosing_topfilings', 'public');
                        $card['image'] = $imagePath;
                    } elseif (isset($card['current_image']) && is_string($card['current_image'])) {
                        \Log::info('Image is a string, retaining existing value');
                        $card['image'] = $card['current_image'];
                    } else {
                        \Log::info('No valid image provided, setting to null');
                        $card['image'] = null;
                    }
                    
                    // Ensure other card fields are properly formatted
                    $card['title'] = $card['title'] ?? null;
                    $card['paragraph'] = $card['paragraph'] ?? null;
                }

                // Ensure required fields exist
                $sectionJson['heading'] = $sectionJson['heading'] ?? null;
                $sectionJson['sub_heading'] = $sectionJson['sub_heading'] ?? null;
            }
        }

        // verified section ---------------------------------------------------------------
        if ($this->section_name == 'verified_section') {
            // Handle main image
            if (isset($sectionJson['image']) && $sectionJson['image'] instanceof \Illuminate\Http\UploadedFile) {
                $imagePath = $sectionJson['image']->store('home/verified', 'public');
                $sectionJson['image'] = $imagePath;
            } elseif (isset($sectionJson['current_image']) && is_string($sectionJson['current_image'])) {
                $sectionJson['image'] = $sectionJson['current_image'];
            } else {
                $sectionJson['image'] = null;
            }

            // Handle lists
            if (isset($sectionJson['lists']) && is_array($sectionJson['lists'])) {
                foreach ($sectionJson['lists'] as $i => &$list) {
                    // Icon upload/processing
                    if (isset($list['icon']) && $list['icon'] instanceof \Illuminate\Http\UploadedFile) {
                        $iconPath = $list['icon']->store('home/verified/icons', 'public');
                        $list['icon'] = $iconPath;
                    } elseif (isset($list['current_icon']) && is_string($list['current_icon'])) {
                        $list['icon'] = $list['current_icon'];
                    } else {
                        $list['icon'] = null;
                    }

                    // Ensure other fields exist
                    $list['title'] = $list['title'] ?? null;
                    $list['paragraph'] = $list['paragraph'] ?? null;
                    $list['paragraph_2'] = $list['paragraph_2'] ?? null;
                    $list['button_text'] = $list['button_text'] ?? null;
                }
            } else {
                // Ensure lists is always an array of 4 items
                $sectionJson['lists'] = array_fill(0, 4, [
                    'title' => null,
                    'paragraph' => null,
                    'icon' => null,
                    'paragraph_2' => null,
                    'button_text' => null
                ]);
            }

            // Ensure required fields exist
            $sectionJson['heading'] = $sectionJson['heading'] ?? null;
        }
        
        $this->attributes['section_json'] = json_encode($sectionJson);
    }

    /**
     * Get the section_json attribute
     *
     * @param  mixed  $value
     * @return array
     */
    public function getSectionJsonAttribute($value)
    {
        $decoded = json_decode($value, true);
        
        // Ensure we always return an array with the expected structure
        return is_array($decoded) ? $decoded : [
            'heading' => null,
            'sub_heading' => null,
            'cards' => array_fill(0, 3, [
                'title' => null,
                'description' => null,
                'image' => null,
                'link' => null
            ])
        ];
    }
}