@extends('frontend.layout')
@section('title', $blog->title)
@section('content')

@php
    // Parse tags from comma-separated string to array
    $tags = !empty($blog->tags) ? array_map('trim', explode(',', $blog->tags)) : [];
    
    // Get FAQ data - handle different formats
    $faqs = [];
    if (!empty($blog->faq_json)) {
        if (is_array($blog->faq_json)) {
            $faqs = $blog->faq_json;
        } else {
            $decoded = json_decode($blog->faq_json, true);
            $faqs = is_array($decoded) ? $decoded : [];
        }
    }
    
    // Convert FAQ array to simple format if it's in "new_1", "new_2" format
    if (!empty($faqs) && isset($faqs['new_1'])) {
        $faqs = array_values($faqs);
    }
@endphp

<!--=================|| About Us Sec start ||============================-->
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url({{ asset('frontend/images/about-us/page_bg01.jpg') }});">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h2>{{ $blog->title }}</h2>
               <div class="card-categories-v3" style="border:unset;">
                  @foreach($tags as $tag)
                  <span class="category-tag-v3">{{ $tag }}</span>
                  @endforeach
                  <span class="category-tag-v3">{{ $blog->created_at->format('F d, Y') }}</span>
               </div>
            </div>
         </div>
      </div>
   </div>
</section>
<!--=================|| About Us start ||============================-->

<!--=================|| Blog Content Section ||============================-->
<section class="blog-content-section ptb100">
   <div class="container">
      <div class="blog-content">
         @if($blog->feature_image)
         <div class="featured-image">
            <img src="{{ asset('storage/' . $blog->feature_image) }}" alt="{{ $blog->title }}" class="img-fluid">
         </div>
         @endif
         
         @if(!empty($blog->description))
         <div class="blog-description">
            {!! $blog->description !!}
         </div>
         @endif
      </div>
   </div>
</section>

<!--=================|| FAQ  start ||============================-->
@if(!empty($faqs))
<section class="faq_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h2>Frequently Asked Questions</h2>
      </div>
      <div class="accordion pt40">
         @foreach($faqs as $index => $faq)
         <div class="accordion-item">
            <div class="accordion-header">
               {{ $index + 1 }}. {{ $faq['question'] ?? 'Question' }}
               <span class="icon"><i class="fa-solid fa-plus"></i></span>
            </div>
            <div class="accordion-body" style="display: none;">
               {!! isset($faq['answer']) ? nl2br(e($faq['answer'])) : 'Answer not available.' !!}
            </div>
         </div>
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| FAQ  End ||============================-->

<script>
  $(document).ready(function() {
    $('.accordion-header').click(function () {
      const parent = $(this).parent();
      const body = parent.find('.accordion-body');
      const icon = $(this).find('.icon');

      // Close all other bodies and reset their icons
      $('.accordion-item').not(parent).each(function () {
        $(this).find('.accordion-body').slideUp();
        $(this).find('.icon').html('<i class="fa-solid fa-plus"></i>');
      });
      
      // Toggle current body
      body.slideToggle();

      // Toggle icon
      const isOpen = icon.html().includes('fa-plus');
      icon.html(isOpen 
        ? '<i class="fa-solid fa-minus"></i>' 
        : '<i class="fa-solid fa-plus"></i>');
    });
  });
</script>

@endsection