@extends('frontend.layout')
@section('title', 'Accounting and Bookkeeping')
@section('content')

@php
    $blogSection = $page->sections->firstWhere('section_name', 'home_blog_section');
@endphp

@if($blogSection)
<!--=================|| Banner Us Sec start ||============================-->
<section class="about_us_sec pt200 pb100 privacy_banner" style="background-image: url(frontend/images/about-us/page_bg01.jpg);">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5>{{ $blogSection->section_json['sub_heading'] }}</h5>
               <h2>{{ $blogSection->section_json['heading'] }}</h2>
            </div>
         </div>
      </div>
   </div>
</section>
<!--=================|| Banner Us End ||============================-->
<!--=================|| Blog Sec Start ||============================-->
<section class="blog_main ptb100">
   <div class="container">
        <div class="blog_grid">
            @forelse($blogs as $blog)
            <a class="blog_box" href="{{url('/blog/'.$blog->slug)}}">
                <div class="featured_img"><img src="{{ asset('storage/'.$blog->feature_image) }}" alt="{{$blog->slug}}"/></div>
                <div class="blog_details">
                    <ul>
                        <li><span><img decoding="async" src="https://wp.xpressbuddy.com/innomax/wp-content/plugins/innomax-core/assets/img/profile-circle.svg" alt=""></span>By admin</li>
                        @php
                            $created_at = \Carbon\Carbon::parse($blog->created_at)->format('d M Y');
                        @endphp
                        <li><span><img decoding="async" src="https://wp.xpressbuddy.com/innomax/wp-content/plugins/innomax-core/assets/img/note.svg" alt=""></span>{{$created_at}}</li>
                    </ul>
                    <h3>{{$blog->title}}</h3>
                    <p>{{$blog->description}}</p>
                </div>
            </a>
            @endforeach
        </div>
    </div>
</section>
<!--=================|| Blog Sec End ||============================-->
@endif

@endsection