@extends('frontend.layout')
@section('title', $page->name)
@section('content')
@php
   $contentFormSection = $page->sections->firstWhere('section_name', 'service_content_form_section');
   $whySection = $page->sections->firstWhere('section_name', 'service_why_section');
   $parallaxSection = $page->sections->firstWhere('section_name', 'parallax_section');
   $iconBoxSection = $page->sections->firstWhere('section_name', 'service_icon_box');
   $businessStructureSection = $page->sections->firstWhere('section_name', 'service_business_structure');
   $titleParagraphSection = $page->sections->firstWhere('section_name', 'title_paragraph_card');
   $blogSection = $page->sections->firstWhere('section_name', 'home_blog_section');

   $contentSection = $page->sections->firstWhere('section_name', 'content');
@endphp

<!--=================|| About Us Sec start ||============================-->
@if($contentFormSection)
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url({{ asset('frontend/images/about-us/page_bg01.jpg') }});">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5>{{ $contentFormSection->section_json['sub_heading'] }}</h5>
               <h2>{{ $contentFormSection->section_json['heading'] }}</h2>
               <p>{{ $contentFormSection->section_json['paragraph'] }}</p>
               <ul class="hero-features">
                  @for($i = 0; $i < 3; $i++)
                     @if(!empty($contentFormSection->section_json["list_$i"]))
                     <li><i class="fa-regular fa-circle-check"></i> {{ $contentFormSection->section_json["list_$i"] }}</li>
                     @endif
                  @endfor
               </ul>
            </div>
         </div>
         <div class="about_right">
            <form action="{{route('enquiry.store')}}" method="post" class="php-email-form">
               @@csrf
               <h3>{{ $contentFormSection->section_json['form_heading'] }}</h3>
               <p>{{ $contentFormSection->section_json['form_sub_heading'] }}</p>
               <input type="hidden" name="type" value="{{ $contentFormSection->section_json['form_heading'] }}">
               <div class="form_inner">
                  <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                  <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                  <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                  <div class="form_box"><button type="submit">{{ $contentFormSection->section_json['form_button_text'] }}</button></div>
               </div>
            </form>
         </div>
      </div>
   </div>
</section>
@endif
<!--=================|| About Us start ||============================-->

<!-- paralax -->
<!--=================|| What is a Sole Proprietorship  Start ||============================-->
@if($parallaxSection)
<section class="what_sole_sec ptb100" style="background-image: url(storage/{{$parallaxSection->section_json['background_image']}});">
   <div class="container">
      <div class="sec_head center_head" bis_skin_checked="1">
         <h2>{{$parallaxSection->section_json['heading']}}</h2>
         <p>{{$parallaxSection->section_json['paragraph']}}</p>
      </div>
   </div>
</section>
@endif
<!--=================||What is a Sole Proprietorship End ||============================-->

@if(request()->is('public-limited-company'))
<!--=================|| Gallery Sec ||============================-->
<section class="gallery_sec ptb100">
   <div class="container">
      <div class="gallery_grid">
         <div class="gallery_box w50">
            <img src="{{asset('frontend/images/imgnew2.png')}}" alt="img" />
            <!-- <h3>Benefits of Public Limited Company Registration</h3> -->
         </div>
         <div class="gallery_box w50">
            <img src="{{asset('frontend/images/imgnew1.png')}}" alt="img" />
            <!-- <h3>Documents Required for Public Limited Company Registration</h3> -->
         </div>
         <div class="gallery_box w100">
            <img src="{{asset('frontend/images/topfilings1.png')}}" alt="img" />
         </div>
      </div>
      <p>Need assistance? Don’t worry, experts are here to help!<br>Call us at:&nbsp;<strong><a href="{{getPhoneNumber()}}" bis_skin_checked="1">{{getPhoneNumber()}}</a></strong>&nbsp;or Email us:&nbsp;<strong><a href="mailto:{{getEmailAddress()}}" bis_skin_checked="1">{{getEmailAddress()}}</a></strong></p>
   </div>
</section>
<!--=================|| Gallery End ||============================-->
@endif

<!--=================|| Why Private Limited  start ||============================-->
@if($whySection && !empty($whySection->section_table))
<section class="why_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h5>{{ $whySection->section_json['sub_heading'] }}</h5>
         <h2>{{ $whySection->section_json['heading'] }}</h2>
      </div>
      <div class="why_grid pt40">
         @foreach($whySection->section_table as $item)
            @if(is_array($item) && !empty($item['title']))
            <div class="service-box">
               <div class="service-item">
                  <h3 class="xb-item--title">{{ $item['title'] }}</h3>
                  <p class="xb-item-contact">{{ $item['paragraph'] }}</p>
                  @if(!empty($item['icon']))
                  <div class="xb-item--img">
                     <img loading="lazy" decoding="async" width="640" height="640" src="{{ asset('storage/' . $item['icon']) }}" class="attachment-full size-full" alt="{{ $item['title'] }}">
                  </div>
                  @endif
               </div>
            </div>
            @endif
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Why Private Limited  End ||============================-->

<!--=================|| Online Company Registration  Start ||============================-->
@if($titleParagraphSection && !empty($titleParagraphSection->section_json))
<section class="document_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2>{{ $titleParagraphSection->section_json['heading'] }}</h2>
      </div>
      <div class="steps-wrapper pt40">
         @for($i = 0; $i <= 6; $i++)
            @if(isset($titleParagraphSection->section_json['card_' . $i]))
            <div class="step-item">
               {!! $titleParagraphSection->section_json['card_' . $i] !!}
            </div>
            @endif
         @endfor
      </div>
   </div>
</section>
@endif
<!--=================|| Online Company Registration  End ||============================-->


<!--=================|| Documents Required  Start ||============================-->
@if($iconBoxSection && !empty($iconBoxSection->section_table))
<section class="document_sec ptb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2>{{$iconBoxSection->section_json['heading']}}</h2>
      </div>
      <div class="featured_grid pt40">
         @foreach($iconBoxSection->section_table as $item)
            @if(is_array($item) && !empty($item['title']))
            <div class="feature-box">
               <div class="icon-container">
                  @if(!empty($item['icon']))
                  <i class="{{ $item['icon'] }}"></i>
                  @endif
               </div>
               <h4>{{ $item['title'] }}</h4>
               <p>{{ $item['paragraph'] }}</p>
            </div>
            @endif
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Documents Required  End ||============================-->

<!--=================|| Business Structure Start ||============================-->
@if($businessStructureSection && !empty($businessStructureSection->section_table))
<section class="business_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h5>{{ $businessStructureSection->section_json['sub_heading'] }}</h5>
         <h2>{{ $businessStructureSection->section_json['heading'] }}</h2>
      </div>
      <div class="business_table pt40">
         <table>
            <thead>
               <tr>
                  <th></th>
                  <th>Private Limited Company</th>
                  <th>One Person Company</th>
                  <th>Limited Liability Partnership</th>
                  <th>Partnership Firm</th>
                  <th>Proprietorship Firm</th>
               </tr>
            </thead>
            <tbody>
               @foreach(array_values($businessStructureSection->section_table) as $item)
               @if(isset($item['service']))
               <tr>
                  <td>{{ $item['service'] }}</td>
                  <td>{{ $item['private_limited_company'] }}</td>
                  <td>{{ $item['one_person_company'] }}</td>
                  <td>{{ $item['limited_liability_partnership'] }}</td>
                  <td>{{ $item['partnership_firm'] }}</td>
                  <td>{{ $item['proprietorship_firm'] }}</td>
               </tr>
               @endif
               @endforeach
            </tbody>
         </table>
      </div>
   </div>
</section>
@endif
<!--=================|| Business Structure End ||============================-->

<!--=================|| Helpful Resources  Start ||============================-->
@if($blogSection)
<section class="helpful_sec ptb100">
   <div class="container">
      <div class="sec_head center_head" bis_skin_checked="1">
        <h2>{{ $blogSection->section_json['heading'] }}</h2>
        <p>{{ $blogSection->section_json['sub_heading'] }}</p>
      </div>
      <div class="helpful_grid pt60">
        @forelse($blogs as $blog)
        <a href="{{url('/blog/'.$blog->slug)}}" class="inner-box">
        <div class="image-box" bis_skin_checked="1">
            <img src="{{ asset('storage/'.$blog->feature_image) }}" alt="{{$blog->slug}}"/>
        </div>
        <div class="content-box" bis_skin_checked="1">
            <span class="date">
                @php
                    $created_at = \Carbon\Carbon::parse($blog->created_at)->format('d M Y');
                @endphp
                {{$created_at}}
            </span>
            @if($blog->tags)
            <ul class="post-info">
                @php
                    $tags = explode(',', $blog->tags);
                @endphp
                @foreach($tags as $tag)
                    <li>{{$tag}}</li>
                @endforeach
            </ul>
            @endif
            <h4 class="title">{{$blog->title}}</h4>
        </div>
        </a>
        @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Helpful Resources  End ||============================-->


<!-- Banner Section -->
@if($contentSection && !empty($contentSection->section_json))
<section class="about_us_sec pt200 pb100 privacy_banner" style="background-image: url({{ asset('frontend/images/about-us/page_bg01.jpg') }});">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5>{{ $contentSection->section_json['sub_heading']}}</h5>
               <h2>{{ $contentSection->section_json['heading']}}</h2>
               <h6>Updated on : {{ $page->updated_at->format('F jS, Y') }}</h6>
            </div>
         </div>
      </div>
   </div>
</section>
@endif

<!-- Content Section -->
@if($contentSection && !empty($contentSection->section_json['content']))
<section class="privacy_sec ptb100">
   <div class="container">
      <div class="privacy_grid">
         <div class="privacy_box">
            {!! $contentSection->section_json['content'] !!}
         </div>
      </div>
   </div>
</section>
@endif

@endsection