@extends('frontend.layout')
@section('title', $page->name)
@section('content')

@php
    // Extract sections from the page data
    $serviceContentSection = $page->sections->firstWhere('section_name', 'service_content_form_section');
    $imageContentSection = $page->sections->firstWhere('section_name', 'image_content_section');
    $virtualCfoWhySection = $page->sections->firstWhere('section_name', 'virtual_cfo_why_section');
    $serviceWhySection = $page->sections->firstWhere('section_name', 'service_why_section');
@endphp

<!--=================|| About Us Sec start ||============================-->
@if($serviceContentSection && !empty($serviceContentSection->section_json))
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url({{ asset('frontend/images/about-us/page_bg01.jpg') }});">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5>{{ $serviceContentSection->section_json['sub_heading'] }}</h5>
               <h2>{{ $serviceContentSection->section_json['heading'] }}</h2>
               <ul class="hero-features">
                  @for($i = 0; $i <= 4; $i++)
                     @if(isset($serviceContentSection->section_json['list_' . $i]))
                     <li><i class="fa-regular fa-circle-check"></i> {{ $serviceContentSection->section_json['list_' . $i] }}</li>
                     @endif
                  @endfor
                  <!-- Additional static items -->
                  <li><i class="fa-regular fa-circle-check"></i> Different services offered for Virtual CFO</li>
                  <li><i class="fa-regular fa-circle-check"></i> Virtual CFO startups</li>
                  <li><i class="fa-regular fa-circle-check"></i> Payroll Management</li>
                  <li><i class="fa-regular fa-circle-check"></i> GST Registration, Human Resource Management, Management of finances, and much more</li>
               </ul>
            </div>
         </div>
         <div class="about_right">
            <form action="{{route('enquiry.store')}}" method="post" class="php-email-form">
               @csrf
               <h3>{{ $serviceContentSection->section_json['form_heading'] }}</h3>
               <p>{{ $serviceContentSection->section_json['form_sub_heading'] }}</p>
               <input type="hidden" name="type" value="{{ $serviceContentSection->section_json['form_heading'] }}">
               <div class="form_inner">
                  <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                  <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                  <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                  <div class="form_box"><button type="submit">{{ $serviceContentSection->section_json['form_button_text'] }}</button></div>
               </div>
            </form>
         </div>
      </div>
   </div>
</section>
@endif
<!--=================|| About Us start ||============================-->

<!--=================|| Image Content Sections ||============================-->
@if($imageContentSection && !empty($imageContentSection->section_table))
@php
    $imageContentItems = array_values($imageContentSection->section_table);
@endphp

@foreach($imageContentItems as $index => $item)
@if(isset($item['title']) && isset($item['paragraph']))
<section class="vitual_seo_sec {{ $index === 0 ? 'ptb100' : 'pb100' }}">
   <div class="container">
      <div class="our_misson_grid">
         @if($index % 2 === 0)
         <div class="our_mission_left">
            <div class="sec_head">
               <h2>{{ $item['title'] }}</h2>
            </div>
            <div class="mission_content">
               {!! nl2br(e($item['paragraph'])) !!}
            </div>
         </div>
         <div class="our_mission_right">
            <img src="{{ asset('storage/' . $item['image']) }}" alt="{{ $item['title'] }}">
         </div>
         @else
         <div class="our_mission_right">
            <img src="{{ asset('storage/' . $item['image']) }}" alt="{{ $item['title'] }}">
         </div>
         <div class="our_mission_left">
            <div class="sec_head">
               <h2>{{ $item['title'] }}</h2>
            </div>
            <div class="mission_content">
               {!! nl2br(e($item['paragraph'])) !!}
            </div>
         </div>
         @endif
      </div>
   </div>
</section>
@endif
@endforeach
@endif
<!--=================|| Image Content Sections End ||============================-->

<!--=================|| Why Virtual CFO ? Start ||============================-->
@if($virtualCfoWhySection && !empty($virtualCfoWhySection->section_table))
<section class="why_virtual_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h5>{{ $virtualCfoWhySection->section_json['sub_heading'] }}</h5>
         <h2>{{ $virtualCfoWhySection->section_json['heading'] }}</h2>
      </div>
      <div class="icon_grid pt40">
         @foreach(array_values($virtualCfoWhySection->section_table) as $index => $item)
         @if(isset($item['title']) && isset($item['paragraph']))
         <div class="icon_box">
            @if(isset($item['icon']))
            <img src="{{ asset('storage/' . $item['icon']) }}" alt="{{ $item['title'] }}">
            @else
            <img src="{{ asset('images/about-us/icon' . ($index + 1) . '.svg') }}" alt="{{ $item['title'] }}">
            @endif
            <h4>{{ $item['title'] }}</h4>
            <p>{{ $item['paragraph'] }}</p>
         </div>
         @endif
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Why Virtual CFO ? End ||============================-->

<!--=================|| Service Why Section Start ||============================-->
@if($serviceWhySection && !empty($serviceWhySection->section_table))
<section class="why_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h2>{{ $serviceWhySection->section_json['heading'] }}</h2>
      </div>
      <div class="why_grid pt40">
         @foreach(array_values($serviceWhySection->section_table) as $index => $item)
         @if(isset($item['title']) && isset($item['paragraph']))
         <div class="service-box">
            <div class="service-item">
               <h3 class="xb-item--title">{{ $item['title'] }}</h3>
               <p class="xb-item-contact">{{ $item['paragraph'] }}</p>
               <div class="xb-item--img">
                  @if(isset($item['icon']))
                  <img loading="lazy" decoding="async" width="640" height="640" src="{{ asset('storage/' . $item['icon']) }}" class="attachment-full size-full" alt="{{ $item['title'] }}">
                  @else
                  <img loading="lazy" decoding="async" width="640" height="640" src="{{ asset('images/inner/icon' . ($index + 1) . '.gif') }}" class="attachment-full size-full" alt="{{ $item['title'] }}">
                  @endif
               </div>
            </div>
         </div>
         @endif
         @endforeach
      </div>
   </div>
</section>
@endif
<!--=================|| Service Why Section End ||============================-->

@endsection