
<?php $__env->startSection('title', 'Compliances'); ?>
<?php $__env->startSection('content'); ?>

<?php
    // Extract sections from the page data
    $contentFormSection = $page->sections->firstWhere('section_name', 'service_content_form_section');
    $whySection = $page->sections->firstWhere('section_name', 'service_why_section');
    $iconBoxSection = $page->sections->firstWhere('section_name', 'service_icon_box');
    $parallaxSection = $page->sections->firstWhere('section_name', 'parallax_section');
    $blogSection = $page->sections->firstWhere('section_name', 'home_blog_section');
?>

<!--=================|| About Us Sec start ||============================-->
<?php if($contentFormSection): ?>
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url(<?php echo e(asset('frontend/images/about-us/page_bg01.jpg'), false); ?>);">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5><?php echo e($contentFormSection->section_json['sub_heading'], false); ?></h5>
               <h2><?php echo e($contentFormSection->section_json['heading'], false); ?></h2>
               <p><?php echo e($contentFormSection->section_json['paragraph'], false); ?></p>
               <ul class="hero-features">
                  <?php for($i = 0; $i < 3; $i++): ?>
                     <?php if(!empty($contentFormSection->section_json["list_$i"])): ?>
                     <li><i class="fa-regular fa-circle-check"></i> <?php echo e($contentFormSection->section_json["list_$i"], false); ?></li>
                     <?php endif; ?>
                  <?php endfor; ?>
               </ul>
            </div>
         </div>
         <div class="about_right">
            <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form">
               <?php echo csrf_field(); ?>
               <h3><?php echo e($contentFormSection->section_json['form_heading'], false); ?></h3>
               <p><?php echo e($contentFormSection->section_json['form_sub_heading'], false); ?></p>
               <input type="hidden" name="type" value="<?php echo e($contentFormSection->section_json['form_heading'], false); ?>">
               <div class="form_inner">
                  <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                  <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                  <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                  <div class="form_box"><button type="submit"><?php echo e($contentFormSection->section_json['form_button_text'], false); ?></button></div>
               </div>
            </form>
         </div>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| About Us start ||============================-->

<!--=================|| Why Private Limited  start ||============================-->
<?php if($whySection && !empty($whySection->section_table)): ?>
<section class="why_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h5><?php echo e($whySection->section_json['sub_heading'], false); ?></h5>
         <h2><?php echo e($whySection->section_json['heading'], false); ?></h2>
      </div>
      <div class="why_grid pt40">
         <?php $__currentLoopData = $whySection->section_table; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_array($item) && !empty($item['title'])): ?>
            <div class="service-box">
               <div class="service-item">
                  <h3 class="xb-item--title"><?php echo e($item['title'], false); ?></h3>
                  <p class="xb-item-contact"><?php echo e($item['paragraph'], false); ?></p>
                  <?php if(!empty($item['icon'])): ?>
                  <div class="xb-item--img">
                     <img loading="lazy" decoding="async" width="640" height="640" src="<?php echo e(asset('storage/' . $item['icon']), false); ?>" class="attachment-full size-full" alt="<?php echo e($item['title'], false); ?>">
                  </div>
                  <?php endif; ?>
               </div>
            </div>
            <?php endif; ?>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Why Private Limited  End ||============================-->

<!-- paralax -->
<!--=================|| What is a Sole Proprietorship  Start ||============================-->
<?php if($parallaxSection): ?>
<section class="what_sole_sec ptb100" style="background-image: url(storage/<?php echo e($parallaxSection->section_json['background_image'], false); ?>);">
   <div class="container">
      <div class="sec_head center_head" bis_skin_checked="1">
         <h2><?php echo e($parallaxSection->section_json['heading'], false); ?></h2>
         <p><?php echo e($parallaxSection->section_json['paragraph'], false); ?></p>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================||What is a Sole Proprietorship End ||============================-->

<!--=================|| Documents Required  Start ||============================-->
<?php if($iconBoxSection && !empty($iconBoxSection->section_table)): ?>
<section class="document_sec ptb100">
   <div class="container">
      <div class="sec_head center_head">
         <h2><?php echo e($iconBoxSection->section_json['heading'], false); ?></h2>
      </div>
      <div class="featured_grid pt40">
         <?php $__currentLoopData = $iconBoxSection->section_table; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_array($item) && !empty($item['title'])): ?>
            <div class="feature-box">
               <div class="icon-container">
                  <?php if(!empty($item['icon'])): ?>
                  <i class="<?php echo e($item['icon'], false); ?>"></i>
                  <?php endif; ?>
               </div>
               <h4><?php echo e($item['title'], false); ?></h4>
               <p><?php echo e($item['paragraph'], false); ?></p>
            </div>
            <?php endif; ?>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Documents Required  End ||============================-->

<!-- blog section -->
<!--=================|| Helpful Resources  Start ||============================-->
<?php if($blogSection): ?>
<section class="helpful_sec ptb100">
   <div class="container">
      <div class="sec_head center_head" bis_skin_checked="1">
        <h2><?php echo e($blogSection->section_json['heading'], false); ?></h2>
        <p><?php echo e($blogSection->section_json['sub_heading'], false); ?></p>
      </div>
      <div class="helpful_grid pt60">
        <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <a href="<?php echo e(url('/blog/'.$blog->slug), false); ?>" class="inner-box">
        <div class="image-box" bis_skin_checked="1">
            <img src="<?php echo e(asset('storage/'.$blog->feature_image), false); ?>" alt="<?php echo e($blog->slug, false); ?>"/>
        </div>
        <div class="content-box" bis_skin_checked="1">
            <span class="date">
                <?php
                    $created_at = \Carbon\Carbon::parse($blog->created_at)->format('d M Y');
                ?>
                <?php echo e($created_at, false); ?>

            </span>
            <?php if($blog->tags): ?>
            <ul class="post-info">
                <?php
                    $tags = explode(',', $blog->tags);
                ?>
                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($tag, false); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <?php endif; ?>
            <h4 class="title"><?php echo e($blog->title, false); ?></h4>
        </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Helpful Resources  End ||============================-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-8.2.12\htdocs\topfilings\resources\views/frontend/compliances.blade.php ENDPATH**/ ?>