
<?php $__env->startSection('title', $page->name); ?>
<?php $__env->startSection('content'); ?>

<?php
    // Extract sections from the page data
    $serviceContentSection = $page->sections->firstWhere('section_name', 'service_content_form_section');
    $imageContentSection = $page->sections->firstWhere('section_name', 'image_content_section');
    $virtualCfoWhySection = $page->sections->firstWhere('section_name', 'virtual_cfo_why_section');
    $serviceWhySection = $page->sections->firstWhere('section_name', 'service_why_section');
?>

<!--=================|| About Us Sec start ||============================-->
<?php if($serviceContentSection && !empty($serviceContentSection->section_json)): ?>
<section class="about_us_sec pt200 pb100 service_single" style="background-image: url(<?php echo e(asset('frontend/images/about-us/page_bg01.jpg'), false); ?>);">
   <div class="container">
      <div class="about_grid">
         <div class="about_left">
            <div class="sec_head">
               <h5><?php echo e($serviceContentSection->section_json['sub_heading'], false); ?></h5>
               <h2><?php echo e($serviceContentSection->section_json['heading'], false); ?></h2>
               <ul class="hero-features">
                  <?php for($i = 0; $i <= 4; $i++): ?>
                     <?php if(isset($serviceContentSection->section_json['list_' . $i])): ?>
                     <li><i class="fa-regular fa-circle-check"></i> <?php echo e($serviceContentSection->section_json['list_' . $i], false); ?></li>
                     <?php endif; ?>
                  <?php endfor; ?>
                  <!-- Additional static items -->
                  <li><i class="fa-regular fa-circle-check"></i> Different services offered for Virtual CFO</li>
                  <li><i class="fa-regular fa-circle-check"></i> Virtual CFO startups</li>
                  <li><i class="fa-regular fa-circle-check"></i> Payroll Management</li>
                  <li><i class="fa-regular fa-circle-check"></i> GST Registration, Human Resource Management, Management of finances, and much more</li>
               </ul>
            </div>
         </div>
         <div class="about_right">
            <form action="<?php echo e(route('enquiry.store'), false); ?>" method="post" class="php-email-form">
               <?php echo csrf_field(); ?>
               <h3><?php echo e($serviceContentSection->section_json['form_heading'], false); ?></h3>
               <p><?php echo e($serviceContentSection->section_json['form_sub_heading'], false); ?></p>
               <input type="hidden" name="type" value="<?php echo e($serviceContentSection->section_json['form_heading'], false); ?>">
               <div class="form_inner">
                  <div class="form_box"><input type="text" name="name" id="name" placeholder="Your Name" required=""></div>
                  <div class="form_box"><input type="email" name="email" id="email" placeholder="Your Email" required=""></div>
                  <div class="form_box"><input type="tel" name="number" id="number" placeholder="Your Number" required=""></div>
                  <div class="form_box"><button type="submit"><?php echo e($serviceContentSection->section_json['form_button_text'], false); ?></button></div>
               </div>
            </form>
         </div>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| About Us start ||============================-->

<!--=================|| Image Content Sections ||============================-->
<?php if($imageContentSection && !empty($imageContentSection->section_table)): ?>
<?php
    $imageContentItems = array_values($imageContentSection->section_table);
?>

<?php $__currentLoopData = $imageContentItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if(isset($item['title']) && isset($item['paragraph'])): ?>
<section class="vitual_seo_sec <?php echo e($index === 0 ? 'ptb100' : 'pb100', false); ?>">
   <div class="container">
      <div class="our_misson_grid">
         <?php if($index % 2 === 0): ?>
         <div class="our_mission_left">
            <div class="sec_head">
               <h2><?php echo e($item['title'], false); ?></h2>
            </div>
            <div class="mission_content">
               <?php echo nl2br(e($item['paragraph'])); ?>

            </div>
         </div>
         <div class="our_mission_right">
            <img src="<?php echo e(asset('storage/' . $item['image']), false); ?>" alt="<?php echo e($item['title'], false); ?>">
         </div>
         <?php else: ?>
         <div class="our_mission_right">
            <img src="<?php echo e(asset('storage/' . $item['image']), false); ?>" alt="<?php echo e($item['title'], false); ?>">
         </div>
         <div class="our_mission_left">
            <div class="sec_head">
               <h2><?php echo e($item['title'], false); ?></h2>
            </div>
            <div class="mission_content">
               <?php echo nl2br(e($item['paragraph'])); ?>

            </div>
         </div>
         <?php endif; ?>
      </div>
   </div>
</section>
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<!--=================|| Image Content Sections End ||============================-->

<!--=================|| Why Virtual CFO ? Start ||============================-->
<?php if($virtualCfoWhySection && !empty($virtualCfoWhySection->section_table)): ?>
<section class="why_virtual_sec pb100">
   <div class="container">
      <div class="sec_head center_head">
         <h5><?php echo e($virtualCfoWhySection->section_json['sub_heading'], false); ?></h5>
         <h2><?php echo e($virtualCfoWhySection->section_json['heading'], false); ?></h2>
      </div>
      <div class="icon_grid pt40">
         <?php $__currentLoopData = array_values($virtualCfoWhySection->section_table); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <?php if(isset($item['title']) && isset($item['paragraph'])): ?>
         <div class="icon_box">
            <?php if(isset($item['icon'])): ?>
            <img src="<?php echo e(asset('storage/' . $item['icon']), false); ?>" alt="<?php echo e($item['title'], false); ?>">
            <?php else: ?>
            <img src="<?php echo e(asset('images/about-us/icon' . ($index + 1) . '.svg'), false); ?>" alt="<?php echo e($item['title'], false); ?>">
            <?php endif; ?>
            <h4><?php echo e($item['title'], false); ?></h4>
            <p><?php echo e($item['paragraph'], false); ?></p>
         </div>
         <?php endif; ?>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Why Virtual CFO ? End ||============================-->

<!--=================|| Service Why Section Start ||============================-->
<?php if($serviceWhySection && !empty($serviceWhySection->section_table)): ?>
<section class="why_sec pb100">
   <div class="container">
      <div class="sec_head">
         <h2><?php echo e($serviceWhySection->section_json['heading'], false); ?></h2>
      </div>
      <div class="why_grid pt40">
         <?php $__currentLoopData = array_values($serviceWhySection->section_table); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
         <?php if(isset($item['title']) && isset($item['paragraph'])): ?>
         <div class="service-box">
            <div class="service-item">
               <h3 class="xb-item--title"><?php echo e($item['title'], false); ?></h3>
               <p class="xb-item-contact"><?php echo e($item['paragraph'], false); ?></p>
               <div class="xb-item--img">
                  <?php if(isset($item['icon'])): ?>
                  <img loading="lazy" decoding="async" width="640" height="640" src="<?php echo e(asset('storage/' . $item['icon']), false); ?>" class="attachment-full size-full" alt="<?php echo e($item['title'], false); ?>">
                  <?php else: ?>
                  <img loading="lazy" decoding="async" width="640" height="640" src="<?php echo e(asset('images/inner/icon' . ($index + 1) . '.gif'), false); ?>" class="attachment-full size-full" alt="<?php echo e($item['title'], false); ?>">
                  <?php endif; ?>
               </div>
            </div>
         </div>
         <?php endif; ?>
         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
   </div>
</section>
<?php endif; ?>
<!--=================|| Service Why Section End ||============================-->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp-8.2.12\htdocs\topfilings\resources\views/frontend/virtual-cfo.blade.php ENDPATH**/ ?>